## Contributing

ICS Parser is an open source project. It is licensed under the [MIT license](https://opensource.org/licenses/MIT).
We appreciate pull requests, here are our guidelines:

1. Firstly, check if your issue is present within the latest version (`dev-master`) as the problem may already have been fixed.
1. Log a bug in our [issue tracker](https://github.com/u01jmg3/ics-parser/issues) (if there isn't one already).
   - If your patch is going to be large it might be a good idea to get the discussion started early.
     - We are happy to discuss it in an issue beforehand.
   - If you could provide an iCal snippet causing the parser to behave incorrectly it is extremely useful for debugging
     - Please remove all irrelevant events
1. Please follow the coding standard already present in the file you are editing _before_ committing
   - Adhere to the [PSR-2](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-2-coding-style-guide.md) coding standard
   - Use *4 spaces* instead of tabs for indentation
   - Trim all trailing whitespace and blank lines
   - Use single quotes (`'`) where possible instead of double
   - Abide by the [1TBS](https://en.wikipedia.org/wiki/Indent_style#Variant:_1TBS_.28OTBS.29) indentation style
