<?php
/**
 * Pixflow
 */


if(strpos(implode(get_option('active_plugins'),' '),"bookly")>0){
    $args=array(
        'base' => 'md_bookly',
        'name' => esc_html__('Bookly Form', 'massive-dynamic'),
        "category" => esc_html__('Business', 'massive-dynamic'),
        "show_settings_on_create" => false,
        "allowed_container_element" => 'vc_row',
        "params" => array(
            array(
                "type" => "dropdown",
                "edit_field_class" => $filedClass . "glue first last",
                "heading" => esc_attr__("Default Category", 'massive-dynamic'),
                "param_name" => "bookly_category",
                "admin_label" => false,
                "value" => px_get_bookly_categories(),
                "group" => esc_attr__("General", 'massive-dynamic'),
            ),
            array(
                "type" => "dropdown",
                "edit_field_class" => $filedClass . "glue first last",
                "heading" => esc_attr__("Default Service", 'massive-dynamic'),
                "param_name" => "bookly_service",
                "admin_label" => false,
                "value" => px_get_bookly_services(),
                "group" => esc_attr__("General", 'massive-dynamic'),
            ),
            array(
                "type" => "dropdown",
                "edit_field_class" => $filedClass . "glue first last",
                "heading" => esc_attr__("Default Employee", 'massive-dynamic'),
                "param_name" => "bookly_employee",
                "admin_label" => false,
                "value" => px_get_bookly_staff(),
                "group" => esc_attr__("General", 'massive-dynamic'),
            ),
            array(
                'type' => 'md_vc_checkbox',
                "edit_field_class" => $filedClass . "glue first last",
                'heading' => esc_attr__('Hide Category', 'massive-dynamic'),
                'param_name' => 'hide_category',
                'value' => array(esc_attr__('Yes', 'massive-dynamic') => 'categories'),
                'checked' => false,
                "group" => esc_attr__("General", 'massive-dynamic'),
            ),
            array(
                'type' => 'md_vc_checkbox',
                "edit_field_class" => $filedClass . "glue first last",
                'heading' => esc_attr__('Hide Service', 'massive-dynamic'),
                'param_name' => 'hide_service',
                'value' => array(esc_attr__('Yes', 'massive-dynamic') => 'services'),
                'checked' => false,
                "group" => esc_attr__("General", 'massive-dynamic'),
            ),
            array(
                'type' => 'md_vc_checkbox',
                "edit_field_class" => $filedClass . "glue first last",
                'heading' => esc_attr__('Hide Employee', 'massive-dynamic'),
                'param_name' => 'hide_employee',
                'value' => array(esc_attr__('Yes', 'massive-dynamic') => 'staff_members'),
                'checked' => false,
                "group" => esc_attr__("General", 'massive-dynamic'),
            ),
            array(
                'type' => 'md_vc_checkbox',
                "edit_field_class" => $filedClass . "glue first last",
                'heading' => esc_attr__('Hide Date', 'massive-dynamic'),
                'param_name' => 'hide_date',
                'value' => array(esc_attr__('Yes', 'massive-dynamic') => 'date'),
                'checked' => false,
                "group" => esc_attr__("General", 'massive-dynamic'),
            ),
            array(
                'type' => 'md_vc_checkbox',
                "edit_field_class" => $filedClass . "glue first last",
                'heading' => esc_attr__('Hide Week Days', 'massive-dynamic'),
                'param_name' => 'hide_week_days',
                'value' => array(esc_attr__('Yes', 'massive-dynamic') => 'week_days'),
                'checked' => false,
                "group" => esc_attr__("General", 'massive-dynamic'),
            ),
            array(
                'type' => 'md_vc_checkbox',
                "edit_field_class" => $filedClass . "glue first last",
                'heading' => esc_attr__('Hide Time Range', 'massive-dynamic'),
                'param_name' => 'hide_time_range',
                'value' => array(esc_attr__('Yes', 'massive-dynamic') => 'time_range'),
                'checked' => false,
                "group" => esc_attr__("General", 'massive-dynamic'),
            ),
        )
    );
} else {
    $args=array(
        'base' => 'md_bookly',
        'name' => esc_html__('Bookly Form', 'massive-dynamic'),
        "category" => esc_html__('Business', 'massive-dynamic'),
        "show_settings_on_create" => false,
        "allowed_container_element" => 'vc_row',
        "params" => array(array(
            "type" => "md_vc_description",
            "param_name" => "md_active_bookly_description",
            "admin_label" => false,
            "value" => '<strong>' . esc_attr__('Please First Install And  Activate Bookly Plugin', 'massive-dynamic') . '</strong>',
            )
        )
    );
}




/*-----------------------------------------------------------------------------------*/
/*  Bookly
/*-----------------------------------------------------------------------------------*/
pixflow_map($args);

pixflow_add_params('md_bookly', pixflow_addAnimationTab('md_bookly'));
