<?php
/**
 * Icon Shortcode
 *
 * @author Pixflow
 */

add_shortcode('md_icon', 'pixflow_get_style_script'); // pixflow_sc_icon
function pixflow_sc_icon( $atts, $content = null ) {

    extract(shortcode_atts(array(
        'icon_source'               => 'massive_dynamic',
        'icon_icon'                 => 'icon-diamond',
        'icon_url'                  => 'http://',
        'icon_color'                => '#5f5f5f',
        'icon_hover_color'          => '#b6b6b6',
        'icon_fill_color'           => 'rgba(0,0,0,1)',
        'icon_hover_fill_color'     => 'rgba(100,100,100,1)',
        'icon_stroke_color'         => 'rgba(0,0,0,1)',
        'icon_hover_stroke_color'   => 'rgba(100,100,100,1)',
        'icon_size'                 => "153",
        'icon_use_link'             => "No",
        'icon_link'                 => "http://",
        'icon_link_target'          => "_blank",
        'align'                     => 'center',
        'icon_url_png'              => '',
        'tablet_landscape_alignment'    => 'px-tablet-landscape-align-center',
        'mobile_landscape_alignment'    => 'px-mobile-landscape-align-center',
        'mobile_portrait_alignment'    => 'px-mobile-portrait-align-center',
        'tablet_portrait_alignment'    => 'px-tablet-portrait-align-center',

    ), $atts));

    $animation = array();
    $animation = pixflow_shortcodeAnimation('md_icon',$atts);
    $id = pixflow_sc_id('icon');
    $responsive_classes=$tablet_landscape_alignment . " " . $tablet_portrait_alignment . " " . $mobile_landscape_alignment . " " . $mobile_portrait_alignment;

    if('custom-png' == $icon_source && is_numeric($icon_url_png)){
        $icon_url_png =  wp_get_attachment_url( $icon_url_png ) ;
        $icon_url_png = (false == $icon_url_png)?PIXFLOW_PLACEHOLDER1:$icon_url_png;
    }




    ob_start(); ?>

    <style >
        <?php echo '.'.esc_attr($id) ?> .icon{
            color: <?php echo esc_attr($icon_color); ?>;
            font-size: <?php echo esc_attr($icon_size); ?>px;
            transition: color 400ms;
        }

        <?php echo '.'.esc_attr($id) ?> .icon:hover{
                                            color: <?php echo esc_attr($icon_hover_color); ?>;
                                        }
        <?php echo '.'.esc_attr($id);?> .svg{
                                            width:<?php echo esc_attr($icon_size); ?>px;
                                            height:<?php echo esc_attr($icon_size); ?>px;
                                        }
        <?php echo '.'.esc_attr($id);?> .svg path{
                                            fill: <?php echo esc_attr($icon_fill_color); ?>;
                                            stroke: <?php echo esc_attr($icon_stroke_color); ?>;
                                            transition: fill 400ms, stroke 400ms;
                                        }

        <?php echo '.'.esc_attr($id);?> .svg:hover path{
                                            fill: <?php echo esc_attr($icon_hover_fill_color); ?>;
                                            stroke: <?php echo esc_attr($icon_hover_stroke_color); ?>;
                                        }


        <?php echo '.'.esc_attr($id);?> .px-svg-container {
            max-width: <?php echo esc_attr($icon_size) ?>px;
        }

        <?php echo '.'.esc_attr($id);?> .px-svg-container svg{
            width: <?php echo esc_attr($icon_size) ?>px;
        }

    </style>
    <?php
    $align = trim($align);
    ?>
    <div class="md-icon <?php echo esc_attr($id.' '.$animation['has-animation']); ?> md-align-<?php echo esc_attr($align);?>  <?php echo esc_attr($responsive_classes) ?>" <?php echo esc_attr($animation['animation-attrs']); ?>>
        <?php if($icon_source=='massive_dynamic'){
            if($icon_use_link=='yes'){
                ?>
                <a target="<?php echo esc_attr($icon_link_target)?>" href="<?php echo esc_attr($icon_link)?>">
            <?php }?>
            <span class="icon <?php echo esc_attr($icon_icon) ?>"></span>
            <?php
            if($icon_use_link=='yes'){
                ?></a><?php
            }
        }else if($icon_source=='custom'){
            if($icon_use_link=='yes'){
                ?>
                <a target="<?php echo esc_attr($icon_link_target)?>" href="<?php echo esc_attr($icon_link)?>">
            <?php } ?>



            <?php if(pathinfo($icon_url, PATHINFO_EXTENSION)=='svg'){ ?>
                <div class="px-svg-container"><?php px_print_svg($icon_url); ?></div><div class="clearfix"></div>
            <?php }else{ ?>
                <img src="<?php echo esc_attr($icon_url)?>" class="svg" width="<?php echo esc_attr($icon_size)?>">
            <?php } ?>




            <?php
            if($icon_use_link=='yes'){
                ?></a>
            <?php }?>
        <?php } else {
        if($icon_use_link=='yes'){
        ?>
        <a target="<?php echo esc_attr($icon_link_target)?>" href="<?php echo esc_attr($icon_link)?>">
            <?php }?>
            <img src="<?php echo esc_attr($icon_url_png)?>" class="" width="<?php echo esc_attr($icon_size)?>">
            <?php
            if($icon_use_link=='yes'){
            ?></a>
            <?php }?>
        <?php  }?>
    </div>
    <?php
    if($icon_source!='massive_dynamic'){
        ?>
        <script>
            "use strict";
            var $ = (jQuery);
            $(document).ready(function(){
                if(typeof pixflow_iconShortcode == 'function'){
                    pixflow_iconShortcode('<?php echo esc_attr($id)?>');
                }
            });

        </script>
        <?php
    }
    pixflow_callAnimation(true,$animation['animation-type'],'.'.$id);?>
 <?php   return ob_get_clean();
}
