<?php
/**
 * Image Box Full Shortcode
 *
 * @author Pixflow
 */
add_shortcode('md_modern_image_box', 'pixflow_get_style_script');

function pixflow_sc_modern_image_box( $atts, $content = null ) {

    extract(shortcode_atts(array(
        'md_modern_image_box_title'                 => 'The Room',
        'md_modern_image_box_title_color'           => '#FFFFFF',
        'md_modern_image_box_subtitle'              => 'Startup Solution',
        'md_modern_image_box_subtitle_color'        => '#FF41A0',
        'md_modern_image_box_image'                 => '',
        'md_modern_image_box_image_overlay'         => 'rgba(0,0,0,0.3)',
        'md_modern_image_box_image_height'          => '650',
        'md_modern_image_box_image_link'            => '#',
        'md_modern_image_box_image_link_target'     => '_self'
    ), $atts));
    $animation = array();
    $animation = pixflow_shortcodeAnimation('md_modern_image_box',$atts);

    $id = pixflow_sc_id('md_modern_image_box');

    if( is_numeric($md_modern_image_box_image) ){
        $md_modern_image_box_image =  wp_get_attachment_url( $md_modern_image_box_image ) ;
        $md_modern_image_box_image = (false == $md_modern_image_box_image)?PIXFLOW_PLACEHOLDER1:$md_modern_image_box_image;
    }

    ob_start();?>
    <style >

        <?php if($md_modern_image_box_image_link !='' && $md_modern_image_box_image_link != "#") { ?>
            .<?php echo esc_attr($id) ?> a:before{
                content: "";
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background-color: <?php  echo esc_attr($md_modern_image_box_image_overlay) ?>;
            }
        <?php }  else { ?>
            .<?php echo esc_attr($id) ?>:before{
                content: "";
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background-color: <?php  echo esc_attr($md_modern_image_box_image_overlay) ?>;
            }
        <?php } ?>


        .modern-image-box-top-title,.modern-image-box-bottom-title{

        }

        .modern-image-box-meta-container{
            left: calc(15px + (63 - 15) * ((100vw - 320px) / (1920 - 320)));
            bottom: 70px;
            position: absolute;
        }





        <?php echo ".".$id ?> .modern-image-box-container{
            height: <?php echo esc_attr($md_modern_image_box_image_height . "px"); ?>;
            overflow:hidden;
            background: url("<?php echo esc_url($md_modern_image_box_image) ?>");
            background-size: cover;
            background-repeat: no-repeat;
            background-position: center center;

       }

        <?php echo ".".$id ?> .modern-image-box-bottom-title{
            color: <?php echo esc_attr($md_modern_image_box_title_color) ?>;
        }

        <?php echo ".".$id ?> .modern-image-box-top-title{
            color: <?php echo esc_attr($md_modern_image_box_subtitle_color) ?>;
        }

        .modern-image-box-bottom-title{
            font-size: calc(35px + (38 - 35) * ((100vw - 320px) / (1920 - 320)));
            font-weight: bold;
            line-height: calc(43px + (48 - 43) * ((100vw - 320px) / (1920 - 320)));;
        }

        .modern-image-box-top-title{
            font-size: calc(17px + (19 - 17) * ((100vw - 320px) / (1920 - 320)));
            font-weight: bold;
            line-height: calc(24px + (30 - 24) * ((100vw - 320px) / (1920 - 320)));;
        }



        @media (min-width: 750px  ) and (max-width:1200px){
            <?php echo ".".$id ?> .modern-image-box-container{
                height: <?php echo (string)((int)($md_modern_image_box_image_height * 0.8)) . "px"; ?>;


            }
        }

    </style>

    <div class="modern-image-box clearfix <?php echo esc_attr($id.' '.$animation['has-animation']) ?>"  <?php echo esc_attr($animation['animation-attrs']); ?>>
        <?php if($md_modern_image_box_image_link !='' && $md_modern_image_box_image_link != "#") { ?>
            <a class="modern-image-box-link" href="<?php echo esc_attr($md_modern_image_box_image_link) ?>" target="<?php echo esc_attr($md_modern_image_box_image_link_target) ?>" title="<?php echo esc_attr($md_modern_image_box_title) ?>">
                <div class="modern-image-box-container">
                    <div class="modern-image-box-meta-container">
                        <p class="modern-image-box-top-title">— <?php echo esc_attr($md_modern_image_box_subtitle) ?></p>
                        <p class="modern-image-box-bottom-title"><?php echo esc_attr($md_modern_image_box_title) ?></p>
                    </div>
                </div>
            </a>
        <?php } else { ?>
            <div class="modern-image-box-container">
                <div class="modern-image-box-meta-container">
                    <p class="modern-image-box-top-title">— <?php echo esc_attr($md_modern_image_box_subtitle) ?></p>
                    <p class="modern-image-box-bottom-title"><?php echo esc_attr($md_modern_image_box_title) ?></p>
                </div>
            </div>
        <?php } ?>


    </div>
    <script>
        "use strict";
        if ( typeof pixflow_imageboxFull == 'function' )
        {
            //pixflow_imageboxFull();
        }
        <?php pixflow_callAnimation(false,$animation['animation-type'],'.'.$id); ?>
    </script>
    <?php
    return ob_get_clean();
}
