<?php
/**
 * Pixflow
 */

/*-----------------------------------------------------------------------------------*/
/*  Modern Image Box
/*-----------------------------------------------------------------------------------*/
global $separatorCounter;
$separatorCounter = 1;
pixflow_map(
    array(
        "name" => "Modern Image Box",
        "base" => "md_modern_image_box",
        "category" => esc_attr__('Media','massive-dynamic'),
        'show_settings_on_create' => false,
        "allowed_container_element" => 'vc_row',
        'show_settings_on_create' => false,
        "params" => array(
            array(
                "type" => "textfield",
                "edit_field_class" => $filedClass . "glue first",
                "heading" => esc_attr__("Bottom Title", 'massive-dynamic'),
                "value" => "The Room",
                "param_name" => "md_modern_image_box_title",
                "group" => esc_attr__('General', 'massive-dynamic'),
                "description" => esc_attr__("Image Box Modern heading text", 'massive-dynamic'),
                "admin_label" => false,
            ),
            array(
                "type" => 'md_vc_separator',
                "param_name" => "md_modern_image_box_separator1",
                "group" => esc_attr__("General", 'massive-dynamic'),
            ),
            array(
                "type" => "md_vc_colorpicker",
                "edit_field_class" => $filedClass . "glue last",
                "heading" => esc_attr__("Bottom Title Color", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_title_color",
                "value" => '#ffffff',
                "group" => esc_attr__('General', 'massive-dynamic'),
                "admin_label" => false,
            ),
            array(
                "type" => "textfield",
                "edit_field_class" => $filedClass . "glue first",
                "heading" => esc_attr__("Top Title", 'massive-dynamic'),
                "value" => "The Room",
                "param_name" => "md_modern_image_box_subtitle",
                "group" => esc_attr__('General', 'massive-dynamic'),
                "description" => esc_attr__("Image Box Modern sub heading text", 'massive-dynamic'),
                "admin_label" => false,
            ),
            array(
                "type" => 'md_vc_separator',
                "param_name" => "md_modern_image_box_separator2",
                "group" => esc_attr__("General", 'massive-dynamic'),
            ),
            array(
                "type" => "md_vc_colorpicker",
                "edit_field_class" => $filedClass . "glue last",
                "heading" => esc_attr__("Top Title Color", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_subtitle_color",
                "value" => '#ffffff',
                "group" => esc_attr__('General', 'massive-dynamic'),
                "admin_label" => false,
            ),
            array(
                'type' => 'attach_image',
                "edit_field_class" => $filedClass . "glue  first",
                'heading' => esc_attr__('Choose Image', 'massive-dynamic'),
                'param_name' => 'md_modern_image_box_image',
                "group" => esc_attr__("General", 'massive-dynamic'),
            ),
            array(
                "type" => "md_vc_colorpicker",

                "edit_field_class" => $filedClass . "glue last",
                "heading" => esc_attr__("Overlay Color", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_image_overlay",
                "value" => 'rgba(0,0,0,0.3)',
                "admin_label" => false,
                "opacity" => true,
                "group" => esc_attr__("General", 'massive-dynamic'),
            ),
            array(
                "type" => "textfield",
                "edit_field_class" => $filedClass . "glue first last",
                "heading" => esc_attr__("Image Height in Pixels", 'massive-dynamic'),
                "value" => "650",
                "param_name" => "md_modern_image_box_image_height",
                "group" => esc_attr__('General', 'massive-dynamic'),
                "admin_label" => false,
            ),
            array(
                "type" => "textfield",
                "edit_field_class" => $filedClass . "glue first",
                "heading" => esc_attr__("Image Link", 'massive-dynamic'),
                "value" => "#",
                "param_name" => "md_modern_image_box_image_link",
                "group" => esc_attr__('General', 'massive-dynamic'),
                "admin_label" => false,
            ),
            array(
                "type" => 'md_vc_separator',
                "param_name" => "md_modern_image_box_separator3",
                "group" => esc_attr__("General", 'massive-dynamic'),
            ),
            array(
                "type" => "dropdown",
                "edit_field_class" => $filedClass . "glue last",
                "heading" => esc_attr__("Open Mode", 'massive-dynamic'),
                "group" => esc_attr__("General", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_image_link_target",
                "admin_label" => false,
                "value" => array(
                    esc_attr__("Open in same window", 'massive-dynamic') => "_self",
                    esc_attr__("Open in new window", 'massive-dynamic') => "_blank"
                ),

            ),//btn target

        )
    )
);

pixflow_add_params('md_modern_image_box', pixflow_addAnimationTab('md_modern_image_box'));
