<?php
/**
 * Image Box Full Shortcode
 *
 * @author Pixflow
 */
add_shortcode('md_modern_image_box_pro', 'pixflow_get_style_script');

function pixflow_sc_modern_image_box_pro( $atts, $content = null ) {
    global $md_allowed_HTML_tags;

    extract(shortcode_atts(array(
        'md_modern_image_box_pro_icon_source'                       => '',
        'md_modern_image_box_pro_icon'                              => 'icon-diamond',
        'md_modern_image_box_pro_icon_color'                        => '',
        'md_modern_image_box_pro_icon_image'                        => '',
        'md_modern_image_pro_box_title'                             => 'Startup Solution',
        'md_modern_image_box_pro_title_color'                       => '',
        'md_modern_image_box_pro_desc'                              => 'No more fumbling to unlock your phone and find your notes app; Cheatsheet is as easy as pulling down center, pulling up the keyboard, or glancing at your Apple Watch.',
        'md_modern_image_box_pro_desc_color'                        => '#FFFFFF',
        'md_modern_image_box_pro_background_type'                   => '',
        'md_modern_image_box_pro_image'                             => '',
        'md_modern_image_box_pro_image_hover_color'                 => 'rgba(0,0,0,0.3)',
        'md_modern_image_box_pro_color'                             => '#4149FF',
        'md_modern_image_box_pro_image_height'                      => '650',
        'md_modern_image_box_pro_button'                            => 'yes',
        'md_modern_image_box_pro_button_style'                      => 'true',
        'md_modern_image_box_pro_button_text'                       => 'Learn More',
        'md_modern_image_box_pro_button_icon'                       =>  'icon-diamond',
        'md_modern_image_box_pro_button_color'                      => '#fff',
        'md_modern_image_box_pro_button_text_color'                 => '#fff',
        'md_modern_image_box_pro_button_bg_hover_color'             => '#fff',
        'md_modern_image_box_pro_button_hover_color'                => '#fff',
        'md_modern_image_box_pro_button_size'                       => 'standard',
        'md_modern_image_box_pro_left_right_padding'                => '',
        'md_modern_image_box_pro_button_url'                        => '#',
        'md_modern_image_box_pro_button_target'                     => '_self',

    ), $atts));
    $animation = array();
    $animation = pixflow_shortcodeAnimation('md_modern_image_box_pro',$atts);

    $id = pixflow_sc_id('md_modern_image_box_pro');

    if( is_numeric($md_modern_image_box_pro_image) ){
        $md_modern_image_box_pro_image =  wp_get_attachment_url( $md_modern_image_box_pro_image ) ;
        $md_modern_image_box_pro_image = (false == $md_modern_image_box_pro_image)?PIXFLOW_PLACEHOLDER1:$md_modern_image_box_pro_image;
    }

    if( is_numeric($md_modern_image_box_pro_icon_image) ){
        $md_modern_image_box_pro_icon_image =  wp_get_attachment_url( $md_modern_image_box_pro_icon_image ) ;
        $md_modern_image_box_pro_icon_image = (false == $md_modern_image_box_pro_icon_image)?PIXFLOW_PLACEHOLDER1:$md_modern_image_box_pro_icon_image;
    }

    ob_start();?>
    <style >

        .<?php echo esc_attr($id) ?>{
            position: relative;
            overflow: hidden;
            height: <?php echo esc_attr($md_modern_image_box_pro_image_height) ?>px ;
            <?php if($md_modern_image_box_pro_background_type=='image'){ ?>
                background-image:url("<?php echo esc_url($md_modern_image_box_pro_image) ?>");
                background-size: cover;
                background-repeat: no-repeat;
                background-position: center;
            <?php } else { ?>
                background-color: <?php echo esc_attr($md_modern_image_box_pro_color) ?> ;
            <?php } ?>
        }


        .row-equal-column-height .<?php echo esc_attr($id) ?>{

            height: <?php echo esc_attr($md_modern_image_box_pro_image_height) ?>px !important;

        }

        <?php if ($md_modern_image_box_pro_background_type == 'image'){ ?>
            .<?php echo esc_attr($id) ?>:before{
                content: "";
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background-color: <?php  echo esc_attr($md_modern_image_box_pro_image_hover_color) ?>;
            }
        <?php } ?>

        .<?php echo esc_attr($id) ?> .modern-image-box-pro-icon-section .icon{
            color: <?php echo esc_attr($md_modern_image_box_pro_icon_color) ?>;
        }

        .<?php echo esc_attr($id) ?> .modern-image-box-pro-title{
            color: <?php echo esc_attr($md_modern_image_box_pro_title_color) ?>;
        }

        .<?php echo esc_attr($id) ?> .modern-image-box-pro-desc{
            color: <?php echo esc_attr($md_modern_image_box_pro_desc_color) ?>;
        }

    </style>

    <div class="modern-image-box-pro clearfix <?php echo esc_attr($id.' '.$animation['has-animation']) ?>"  <?php echo esc_attr($animation['animation-attrs']); ?> data-height="<?php echo esc_attr($md_modern_image_box_pro_image_height) ?>">
        <div class="modern-image-box-pro-icon-section">
            <?php if($md_modern_image_box_pro_icon_source != 'custom'){ ?>

                <span class="icon <?php echo esc_attr($md_modern_image_box_pro_icon) ?>"></span>

            <?php } else { ?>

                <img class="modern-image-box-pro-icon" src="<?php echo esc_attr($md_modern_image_box_pro_icon_image) ?>" />

            <?php } ?>
        </div>
        <div class="modern-image-box-pro-content-section">
            <h5 class="modern-image-box-pro-title"><?php echo wp_kses($md_modern_image_pro_box_title,$md_allowed_HTML_tags) ?></h5>
            <p class="modern-image-box-pro-desc">
                <?php echo wp_kses($md_modern_image_box_pro_desc,$md_allowed_HTML_tags) ?>
            </p>
            <?php
            if( 'yes' == $md_modern_image_box_pro_button ) {
                echo pixflow_buttonMaker($md_modern_image_box_pro_button_style, $md_modern_image_box_pro_button_text,$md_modern_image_box_pro_button_icon, $md_modern_image_box_pro_button_url, $md_modern_image_box_pro_button_target,$md_modern_image_box_pro_alignment,$md_modern_image_box_pro_button_size, $md_modern_image_box_pro_button_color,$md_modern_image_box_pro_button_hover_color,$md_modern_image_box_pro_left_right_padding,$md_modern_image_box_pro_button_text_color,$md_modern_image_box_pro_button_bg_hover_color);
            } ?>
        </div>
    </div>
    <script>
        "use strict";
        if ( typeof pixflow_modern_image_box_pro == 'function' )
        {
            pixflow_modern_image_box_pro();
        }
        <?php pixflow_callAnimation(false,$animation['animation-type'],'.'.$id); ?>
    </script>
    <?php
    return ob_get_clean();
}
